#!/bin/bash
logger -t SRS_SERVICE "The srs service has been launched"

# Define options
REMOTE_SERVER="10.10.99.100"
REMOTE_USER="monitor"
#define time between checks
INTERVAL="60"
#define number of pings send during each pingcheck
PING_NUM=5
#define number of responses to consider main server alive
RESP_NUM=1

SSH_LOGIN=$REMOTE_USER@$REMOTE_SERVER
##define functions
#function to define actions taken upon main DPI failure
error_action () {
  ssh $SSH_LOGIN "sudo systemctl stop fastdpi"
  logger FASTDPI proccess error detected on the main server turining on the standby
  echo "FASTDPI proccess error detected on the main server turining on the standby"
  echo "Attempting to turn on links or standby server"
  fdpi_cli dev link state set all up 
  exit 0
}

#function to get fastdpi process PID
get_pid () {
  PID=$(ssh $SSH_LOGIN "pgrep fastdpi_main")
  if [ $? -eq 0 ]
  then
  logger -t SRS_SERVICE "function get_pid. PID got successfully PID=$PID"
  else
  logger -t SRS_SERVICE "function get_pid.couldn't connect via ssh"
  fi
}

#function to get number of up interfaces.
interface_state () {
  INTFCE=$(fdpi_cli dev link state show|grep link|wc -l)
}
#function to do ping check
ping_check () {
   icmp_ch=$(ping -c $PING_NUM $REMOTE_SERVER | grep 'ttl' | wc -l)
}


#get initial pid so we don't start empty
get_pid
PID_OLD="$PID"


#get initial interface status
interface_state
INTFCE_OLD="$INTFCE"


while true
 do
#check if server is reachable via network 
ping_check 
    if [[ "$icmp_ch" -lt "$RESP_NUM" ]]; then
      echo "Main stingray server unreachable via ping"
      error_action
    fi

#accuire pid for further checks
get_pid

#check that  pid is not zero
    if [[ -z "$PID" ]];then
      echo "FASTDPI process on the main server is not running"
      error_action
    fi

#chek that pid did not change
    logger -t SRS_SERVICE "chek that pid did not change, PID_OLD=$PID_OLD and PID=$PID"
    if [[ "$PID_OLD" != "$PID" ]]; then
       echo "FASTDPI process on the main server flapping"
       error_action
    fi

#OPTIONAL check that interface state did not change (uncomment to use)
# interface_state
#       if [[ "$INTFCE_OLD" != "$INTFCE" ]]; then
#          error_action
#          logger DPDK interfaces changed status on the main server
#       fi

sleep "$INTERVAL"
done
